/*=========================================================================================
    File Name: bar.js
    Description: google horizontal bar chart
    ----------------------------------------------------------------------------------------
    Item Name: Robust - Responsive Admin Template
    Version: 2.1
    Author: PIXINVENT
    Author URL: http://www.themeforest.net/user/pixinvent
==========================================================================================*/

// Bar chart
// ------------------------------

// Load the Visualization API and the corechart package.
google.load('visualization', '1.0', {'packages':['corechart']});

// Set a callback to run when the Google Visualization API is loaded.
google.setOnLoadCallback(drawBar);

// Callback that creates and populates a data table, instantiates the pie chart, passes in the data and draws it.
function drawBar() {

    // Create the data table.
    var data = google.visualization.arrayToDataTable([
        ['date', 'SMS', {role: 'style'}, {role: 'annotation'}],
		['2012',  1156329, '#26A0FC',  'Total Requested'],
        ['2013',  51597, '#26E7A6', 'Total Rejected'],
        ['2014',  1104365, '#FEBC3B', 'Total Submitted'],
        ['2015',  874741, '#FF6178', 'Total Delivered'],
		['2015',  223110, '#8B75D7', 'Total Failed'],
		['2015',  6514, '#1e7145', 'Total Awaited']
    ]);


    // Set chart options
    var options_bar = {
		
        height:400,
        fontSize:13,
        chartArea: {left:'5%', width: '96%', height: 350
        },
        hAxis: {
            gridlines:{
                color: '#E4E4E4',
            },
        },
        vAxis: {
            gridlines:{
                count: 10
            },
            minValue: 0
        },
      /*  legend: {
            position: 'top',
            alignment: 'center',
            textStyle: {fontSize: 12}
        }
		*/
    };

    // Instantiate and draw our chart, passing in some options.
    var bar = new google.visualization.BarChart(document.getElementById('bar-chart'));
    bar.draw(data, options_bar);

}


// Resize chart
// ------------------------------

$(function () {

    // Resize chart on menu width change and window resize
    $(window).on('resize', resize);
    $(".menu-toggle").on('click', resize);

    // Resize function
    function resize() {
        drawBar();
    }
});