// Stacked column bar chart
// ------------------------------

// Load the Visualization API and the corechart package.
google.load('visualization', '1.0', {'packages':['corechart']});

// Set a callback to run when the Google Visualization API is loaded.
google.setOnLoadCallback(drawColumnStacked);

// Callback that creates and populates a data table, instantiates the pie chart, passes in the data and draws it.
function drawColumnStacked() {

    // Create the data table.
  
	
	 var data = google.visualization.arrayToDataTable([
       ['Genre', 'Total Submitted', 'Total Delivered', { role: 'annotation' } ],
        ['0', 10, 15, ''],
        ['1', 12, 20, ''],
        ['2', 5, 24, ''],
        ['3', 18, 25, ''],
        ['4', 16, 22, ''],
        ['5', 8, 26, ''],
        ['6', 24, 17, ''],
		 ['7', 24, 17, ''],
		 ['8', 24, 17, ''],
		 ['9', 24, 17, ''],
		 ['10', 24, 17, ''],
		 ['11', 24, 17, ''],
		 ['12', 24, 17, ''],
		 ['13', 18, 25, ''],
		 ['14', 24, 17, ''],
		 ['15', 24, 17, ''],
		 ['16', 18, 25, ''],
		 ['17', 24, 17, ''],
		 ['18', 24, 17, ''],
		 ['19', 24, 17, ''],
		 ['20', 18, 25, ''],
		 ['21', 24, 17, ''],
		 ['22', 24, 17, ''],
		 ['23', 24, 17, '']
		
		
    ]);


    // Set chart options
    var options_column_stacked = {
        height: 400,
        fontSize: 10,
        colors: ['#EE7321','#607D8B'],
        chartArea: {
            left: '5%',
            width: '100%',
            height: 350
        },
        vAxis: {
            gridlines:{
                color: '#e9e9e9',
                count: 10
            },
            minValue: 0
        },
        legend: {
            position: 'top',
            alignment: 'center',
            textStyle: {
                fontSize: 12
            }
        }
    };

    // Instantiate and draw our chart, passing in some options.
    var bar = new google.visualization.ColumnChart(document.getElementById('stacked-column-chart'));
    bar.draw(data, options_column_stacked);

}


// Resize chart
// ------------------------------

$(function () {

    // Resize chart on menu width change and window resize
    $(window).on('resize', resize);
    $(".menu-toggle").on('click', resize);

    // Resize function
    function resize() {
        drawColumnStacked();
    }
});